﻿#nullable enable
namespace Hims.Api.Models.Patient
{
    using System;
    using System.Collections.Generic;
    using Microsoft.AspNetCore.Http;
    using Shared.EntityModels;

    /// <summary>
    /// The modify patient request.
    /// </summary>
    public class ModifyPatientRequest
    {
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? Salutation { get; set; }

        /// <summary>
        /// Gets or sets from.
        /// </summary>
        /// <value>
        /// From.
        /// </value>
        public string? From { get; set; }

        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        public string FirstName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the middle name.
        /// </summary>
        public string? MiddleName { get; set; }

        /// <summary>
        /// Gets or sets the last name.
        /// </summary>
        public string LastName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the father or husband.
        /// </summary>
        public string FatherOrHusband { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string AadharNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        public string? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public short? Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }



        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string Email { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the street address.
        /// </summary>
        public string? StreetAddress { get; set; }

        /// <summary>
        /// Gets or sets the address line 2.
        /// </summary>
        public string? AddressLine2 { get; set; }

        /// <summary>
        /// Gets or sets the city.
        /// </summary>
        public string? City { get; set; }

        /// <summary>
        /// Gets or sets the state.
        /// </summary>
        public string? State { get; set; }

        /// <summary>
        /// Gets or sets the Zipcode.
        /// </summary>
        public string? Zipcode { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        ///  public int CountryId { get; set; } 
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the profile image url.
        /// </summary>
        public string? ProfileImageUrl { get; set; }

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string? ThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the base 64 profile image.
        /// </summary>
        public string? Base64ProfileImage { get; set; }

        /// <summary>
        /// Gets or sets the password.
        /// </summary>
        public string? Password { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the emergency contacts.
        /// </summary>
        public List<PatientEmergencyModel>? EmergencyContacts { get; set; }

        /// <summary>
        /// Gets or sets the insurances.
        /// </summary>
        public List<PatientInsuranceModel>? Insurances { get; set; }

        /// <summary>
        /// Gets or sets the relative details.
        /// </summary>
        public List<PatientFamilyModel>? RelativeDetails { get; set; }

        /// <summary>
        /// Gets or sets the referral code.
        /// </summary>
        public string? ReferralCode { get; set; }

        /// <summary>
        /// Gets or sets the referral code.
        /// </summary>
        public int? ReferralBy { get; set; }


        /// <summary>
        /// Gets or sets the RoleId.
        /// </summary>
        public short? RoleId { get; set; }
        /// <summary>
        /// Gets or sets the Created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the Created by name.
        /// </summary>
        public string? ModifiedByName { get; set; }
        /// <summary>
        /// Gets or sets the Referred by.
        /// </summary>
        public string? ReferredBy { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? ReferredByName { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the HWC patient identifier.
        /// </summary>
        /// <value>
        /// The HWC patient identifier.
        /// </value>
        public int? HWCPatientId { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Education { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Occupation { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? MaritalStatus { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Religion { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Nationality { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? RelationName { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? RelativeMobile { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? RelativeOccupation { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? RealtiveEducation { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? RelativeDateOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public char? RelativeGender { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Relation { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public int? PatientReferredById { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Name { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? IdProofId { get; set; }

        /// <summary>
        /// Gets or sets the id proof value.
        /// </summary>
        public string? IdProofValue { get; set; }


        /// <summary>
        /// Gets or sets the Blood group
        /// </summary>
        public string? BloodGroup { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool? PaymentStatus { get; set; }

        /// <summary>
        ///  Gets or sets payment number.
        /// </summary>
        public string? PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the Pay type id from payType masters.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal? Charges { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal? Amount { get; set; }

        /// <summary>
        /// Gets or sets the id proof Number.
        /// </summary>
        public string? IdProofNo { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? HowDidYouKnowId { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? EducationId { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? OccupationId { get; set; }
        /// <summary>
        /// Gets or sets the birthMark1.
        /// </summary>
        public string? BirthMark1 { get; set; }
        /// <summary>
        /// Gets or sets the birthMark1.
        /// </summary>
        public string? BirthMark2 { get; set; }
        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string? TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the transaction.
        /// </summary>
        public string? Transaction { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public int? SalucroStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string? SalucroTransactionId { get; set; }
        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public decimal? TotalAmount { get; set; }


        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool? IsUnidentified { get; set; }

        /// <summary>
        /// Gets or sets the type of the relation.
        /// </summary>
        /// <value>
        /// The type of the relation.
        /// </value>
        public string? RelationType { get; set; }

        /// <summary>
        /// Gets or sets the occupation detail.
        /// </summary>
        /// <value>
        /// The occupation detail.
        /// </value>
        public string? OccupationDetail { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public int? PaymentInitiationLogId { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool? SaveRelativeAsPatient { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public string? Relative { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? InsuranceId { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? ReferredByNameId { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public string? DocumentName { get; set; }

        public IFormFileCollection? Files { get; set; } = null;

        /// <summary>
        /// Gets or sets the document type.
        /// </summary>
        public string? DocumentType { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }

        public List<String>? FilePaths { get; set; }

        /// <summary>
        /// Gets or sets the patient total.
        /// </summary>
        public decimal PatientTotal { get; set; }

        public bool IsBabyRegistration { get; set; }
        public int? ParentPatientId { get; set; }

        /// <summary>
        /// Get or sets the total.
        /// </summary>
        public decimal DiscountPerItem { get; set; }

        /// <summary>
        /// Get or sets the total.
        /// </summary>
        public decimal DiscountPerItemInRupees { get; set; }

        /// <summary>
        /// Gets or sets the admission time.
        /// </summary>
        public string? TimeOfBirth { get; set; }

    }
}